﻿<?LassoScript
/*
This demo illustrates how to add color to text or graphic objects.
Colors can be of the types Gray, RGB, CMYK or Spot color.

Author: Jolle Carlestam
Prepared for the Lasso Developer Conference in Chicago 2008
Use and alter freely but please keep a reference to where you found it
*/

//First set some vars holding basic data.
var('pagetype' = 'A4',
	'pageheight' = 842, // points
	'pagewidth' = 595);

// If you prefer US-Letter sized paper uncomment this section
/*
var('pagetype' = 'LETTER',
	'pageheight' = 792, // points
	'pagewidth' = 612);

*/

// Create the pdf_doc object
var( 'pdf' = pdf_doc( -size = $pagetype,
	-margins = array( 25.0, 25.0, 25.0, 25.0), -nocompress));

// Different examples of pdf_color settings
var('gray08' = pdf_color('gray', 0.8));
var('gray03' = pdf_color('gray', 0.3));
var('greenRGB' = pdf_color('rgb', 0, 0.9, 0.1));
var('redRGB' = pdf_color('rgb', 1, 0, 0));
var('blackRGB' = pdf_color('rgb', 0, 0, 0));
var('whiteRGB' = pdf_color('rgb',1,1,1));
var('E64_1CMYK' = pdf_color('cmyk', 0.3, 0.9, 1, 0));
var('whiteCMYK' = pdf_color('cmyk', 0, 0, 0, 0));
var('blackCMYK' = pdf_color('cmyk',1,1,1,1));
var('gray08Spot' = pdf_color('spot', 'GRAY 80',0.1, $gray08));
var('greenSpotRGB' = pdf_color('spot', 'GREEN', 0.9, $greenRGB));
var('E64_1Spot_05CMYK' = pdf_color('spot', 'PANTONE E 64-1', 0.5, $E64_1CMYK));
var('E64_1Spot_10CMYK' = pdf_color('spot', 'PANTONE E 64-1', 1, $E64_1CMYK));

// Draw a rectangle that's filled with gray and place it so it covers the entire page.
$pdf -> setcolor( 'both', $gray03);
$pdf -> rect( 1, 1, $pagewidth, $pageheight, -fill);

// Draw a rectangle that's filled with green and have a red border
$pdf -> setcolor( 'fill', $greenRGB);
$pdf -> setcolor( 'stroke', $redRGB);
$pdf -> setlinewidth(5);
$pdf -> rect( 60, $pageheight - 100, 100, 60, -fill);


// Add some text illustrating different colors
var('text' = pdf_text('Gray example. Tint value set to 0.8', -color = $gray08));
$pdf -> add( $text, -width = 500, -top = 100, -left = 30, -leading = 16);

var('text' = pdf_text('RGB example. Color values set to 0, 0.9, 0.1', -color = $greenRGB));
$pdf -> add($text, -width = 500, -top = 120, -left = 30, -leading = 16);

var('text' = pdf_text('RGB example. Color values set to 0, 0, 0. Looks like Black', -color = $blackRGB));
$pdf -> add($text, -width = 500, -top = 140, -left = 30, -leading = 16);

var('text' = pdf_text('RGB example. Color values set to 1, 1, 1. Looks like White', -color = $whiteRGB));
$pdf -> add($text, -width = 500, -top = 160, -left = 30, -leading = 16);

var('text' = pdf_text('CMYK example. Color values set to 0.3, 0.9, 1, 0. (Emulating Pantone E 64-1)', -color = $E64_1CMYK));
$pdf -> add($text, -width = 500, -top = 180, -left = 30, -leading = 16);

var('text' = pdf_text('CMYK example. Color values set to 0, 0, 0, 0. Will print as White', -color = $whiteCMYK));
$pdf -> add($text, -width = 500, -top = 200, -left = 30, -leading = 16);

var('text' = pdf_text('CMYK example. Color values set to 1, 1, 1, 1. Will print as Black', -color = $blackCMYK));
$pdf -> add($text, -width = 500, -top = 220, -left = 30, -leading = 16);

var('text' = pdf_text('Spot Color Gray example. Color tint set to 80%', -color = $gray08Spot));
$pdf -> add($text, -width = 500, -top = 240, -left = 30, -leading = 16);

var('text' = pdf_text('Spot Color RGB example. Using greenRBG as color with a tint on 90%', -color = $greenSpotRGB));
$pdf -> add($text, -width = 500, -top = 260, -left = 30, -leading = 16);

var('text' = pdf_text('Spot Color CMYK example. Using E64_1CMYK as color with a tint of 50%', -color = $E64_1Spot_05CMYK));
$pdf -> add($text, -width = 500, -top = 280, -left = 30, -leading = 16);

var('text' = pdf_text('Spot Color CMYK example. Using E64_1CMYK as color with a tint of 100%', -color = $E64_1Spot_10CMYK));
$pdf -> add($text, -width = 500, -top = 300, -left = 30, -leading = 16);

var('times'  =  pdf_font( -face = 'Times-Roman', -size = 14));
var('text' = pdf_text('Text using font object with color set when creating text object',
	-font = $times, -color = $greenRGB));
$pdf -> add($text, -width = 500, -top = 320, -left = 30, -leading = 16);

// Using pdf_font with -color
var('courierBold'  =  pdf_font( -face = 'Courier-Bold',  -color = $greenRGB, -size = 14));
var('text' = pdf_text('Text using font object with color set when creating font object',
	-font = $courierBold));
$pdf -> add($text, -width = 500, -top = 340, -left = 30, -leading = 16);


// Using a font object that have a color specified but overriding the color value
var('text' = pdf_text('Even if you use a pdf_font object for your text, the font objects color value can be replaced by setting a color directly in the pdf_text object',
	-font = $courierBold, -color = $gray08));
$pdf -> add($text, -width = 500, -top = 376, -left = 30, -leading = 16);



// Finally close the pdf_doc and serve it
$pdf -> close;
pdf_serve( -content = $pdf, -file = 'demo6.pdf');

?>